/*
 * Decompiled with CFR 0.152.
 */
package view;

import events.PacketState;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import view.Dialogs.EditPacketDialog;
import view.Edge;
import view.Graph;
import view.Vertex;

public abstract class Packet
extends Vertex
implements MouseListener {
    public static final int PACKET_WIDTH = 15;
    public static final int PACKET_HEIGHT = 30;
    private static final int SOURCE_TARGET_SEPARATOR_WIDTH = 1;
    private boolean isDamaged = false;
    private Color bgColor;
    private Color borderColor;
    private Color damagedBorderColor;
    private Color sourceColor;
    private Color targetColor;
    private JLabel label = new JLabel();

    public Packet(int id, Graph g, Color bgColor, Color borderColor, Color damagedBorderColor, Color sourceColor, Color targetColor, int sequenceNumber) {
        super(id, g);
        this.bgColor = bgColor;
        this.borderColor = borderColor;
        this.damagedBorderColor = damagedBorderColor;
        this.sourceColor = sourceColor;
        this.targetColor = targetColor;
        this.label.setHorizontalAlignment(0);
        this.setOpaque(true);
        this.setBackground(bgColor);
        this.setBounds(0, 0, 15, 30);
        this.setPreferredSize(new Dimension(15, 30));
        this.setCaption(Integer.toString(sequenceNumber));
        this.setLayout(new BorderLayout());
        this.setVisible(false);
        this.add((Component)this.label, "South");
    }

    public void changePacketState(PacketState packetState) {
        if (packetState != null) {
            this.isDamaged = packetState.isDamaged();
        }
    }

    public void setProgress(Edge edge, int progress) {
        double yToGo;
        double xToGo;
        Point newPos = new Point(0, 0);
        Point edgeStart = edge.getStartPoint();
        Point edgeEnd = edge.getEndPoint();
        if (edgeStart.getX() > edgeEnd.getX()) {
            edgeStart = edge.getEndPoint();
            edgeEnd = edge.getStartPoint();
        }
        double distance = this.calcDistance(edgeStart, edgeEnd);
        double distanceToNewPos = (double)progress / 100.0 * distance;
        double elevation = this.calcElevation(edgeStart, edgeEnd);
        if (Double.isInfinite(elevation)) {
            xToGo = 0.0;
            yToGo = edgeStart.getY() < edgeEnd.getY() ? distanceToNewPos : -distanceToNewPos;
        } else {
            xToGo = Math.sqrt(Math.pow(distanceToNewPos, 2.0) / (Math.pow(elevation, 2.0) + 1.0));
            yToGo = xToGo * elevation;
        }
        edgeStart = edge.getStartPoint();
        edgeEnd = edge.getEndPoint();
        if (edgeStart.getX() > edgeEnd.getX()) {
            xToGo = -xToGo;
            yToGo = -yToGo;
        }
        newPos.setLocation((double)edge.getX() + edgeStart.getX() + xToGo, (double)edge.getY() + edgeStart.getY() + yToGo);
        this.setPosition(newPos);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        BufferedImage dbImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D dbg = (Graphics2D)dbImage.getGraphics();
        int width = this.getWidth();
        int height = this.getHeight();
        dbg.setColor(this.bgColor);
        dbg.fillRect(0, 0, width, height);
        dbg.setColor(this.sourceColor);
        dbg.fillRect(0, 0, width, height / 4);
        dbg.setColor(Color.black);
        dbg.fillRect(0, height / 4, width, 1);
        dbg.setColor(this.targetColor);
        dbg.fillRect(0, height / 4 + 1, width, height / 4);
        dbg.setColor(this.borderColor);
        if (this.isDamaged) {
            float[] dash = new float[]{5.0f};
            dbg.setColor(this.damagedBorderColor);
            dbg.setStroke(new BasicStroke(1.0f, 0, 0, 5.0f, dash, 0.0f));
        }
        Rectangle border = new Rectangle(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        dbg.draw(border);
        ((Graphics2D)g).drawImage((Image)dbImage, 0, 0, this);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        super.mouseClicked(arg0);
        if (arg0.getClickCount() == 2) {
            PacketState packetState = (PacketState)this.getState();
            EditPacketDialog d = new EditPacketDialog(this.graph, packetState, this.graph);
            PacketState alteredState = d.showDialog();
            this.graph.sendState(alteredState);
        }
    }

    private void setCaption(String caption) {
        this.label.setText(caption);
        this.label.setBounds(0, 0, (int)this.label.getPreferredSize().getWidth() + 7, (int)this.label.getPreferredSize().getHeight() + 3);
        this.resize();
    }

    private void setPosition(Point newPos) {
        this.setBounds((int)newPos.getX() - 7, (int)newPos.getY() - 15, this.getWidth(), this.getHeight());
    }

    private void resize() {
        this.repaint();
        Dimension labelDim = this.label.getPreferredSize();
        int width = Math.max(15, (int)labelDim.getWidth() + 3);
        int height = Math.max(30, (int)labelDim.getHeight() + 3);
        this.setBounds(this.getX(), this.getY(), width, height);
        this.setPreferredSize(new Dimension(width, height));
    }

    private int calcDistance(Point p1, Point p2) {
        int ret = (int)Math.sqrt(Math.pow(p1.getX() - p2.getX(), 2.0) + Math.pow(p1.getY() - p2.getY(), 2.0));
        return ret;
    }

    private double calcElevation(Point p1, Point p2) {
        return (p2.getY() - p1.getY()) / Math.abs(p1.getX() - p2.getX());
    }
}

