/*
 * Decompiled with CFR 0.152.
 */
package view;

import events.BufferState;
import events.ComponentState;
import events.DeviceState;
import events.RouterState;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import view.Device;
import view.Dialogs.EditRouterDialog;
import view.Edge;
import view.Graph;
import view.RouterBufferHandler;

public class Router
extends Device {
    public Router(int id, Graph g) {
        super(id, g);
        this.setIcon("Router.png");
        this.maxLines = 10;
        this.bufferHandler = new RouterBufferHandler(this, g);
    }

    @Override
    public ComponentState getDeleteState() {
        return new RouterState(this.getId(), false, true, null, null, -1, -1, -1, null, null);
    }

    @Override
    public DeviceState getMovedState(Point2D p) {
        return new RouterState(this.getId(), false, false, null, null, (int)p.getX(), (int)p.getY(), -1, null, null);
    }

    @Override
    public void changeDeviceState(DeviceState s) {
        RouterState routerState;
        super.changeDeviceState(s);
        if (!s.isDeleted() && (routerState = (RouterState)s).getBuffers() != null && routerState.getLines() != null) {
            Iterator<Integer> lines = routerState.getLines().iterator();
            Iterator<BufferState> buffers = routerState.getBuffers().iterator();
            while (buffers.hasNext() && lines.hasNext()) {
                BufferState bufferState = buffers.next();
                int lineId = lines.next();
                Edge referedEdge = null;
                Device oppositeDevice = null;
                if (bufferState != null && bufferState.isNew()) {
                    for (Edge e : this.graph.findEdges(lineId)) {
                        if (e == null || e.getTargetId() != this.getId()) continue;
                        referedEdge = e;
                        oppositeDevice = this.graph.findDevice(e.getSourceId());
                    }
                    if (referedEdge != null && oppositeDevice != null) {
                        ((RouterBufferHandler)this.bufferHandler).createBuffer(bufferState, oppositeDevice, referedEdge);
                    }
                }
                this.bufferHandler.changeBuffer(bufferState);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        super.mouseClicked(arg0);
        if (!this.graph.isInSimulation() && !this.graph.isPaused() && arg0.getClickCount() == 2) {
            RouterState routerState = (RouterState)this.getState();
            EditRouterDialog d = new EditRouterDialog(this.graph, this.getName(), routerState, this.graph);
            RouterState alteredState = d.showDialog();
            this.graph.sendState(alteredState);
        }
    }
}

