/*
 * Decompiled with CFR 0.152.
 */
package view;

import events.BufferState;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import view.AbstractBufferHandler;
import view.Buffer;
import view.Device;
import view.Edge;
import view.Graph;

public class RouterBufferHandler
extends AbstractBufferHandler {
    List<Buffer> buffers = new LinkedList<Buffer>();
    public static final int OFFSET = 0;

    public RouterBufferHandler(Device device, Graph graph) {
        super(device, graph);
    }

    @Override
    public boolean changeBuffer(BufferState s) {
        boolean ret = false;
        ret = s.isDeleted() ? this.removeBuffer(this.buffers, s) : this.updateBuffer(this.buffers, s);
        if (ret) {
            this.repaintBuffers();
        }
        return ret;
    }

    @Override
    public Buffer createBuffer(BufferState s, Device oppositeDevice, Edge referredEdge) {
        this.buffers.add(super.createBuffer(s, oppositeDevice, referredEdge));
        return null;
    }

    @Override
    public void repaintBuffers() {
        Rectangle r = this.device.getBounds();
        for (Buffer b : this.buffers) {
            int x = 0;
            int y = 0;
            int[] position = this.device.getLinePosition(b.getReferredEdge());
            int sideOffset = -(position[0] - 1) * 14 + (position[0] - 1 - position[1]) * 2 * 14;
            if (b.getSide() == 1) {
                x = (int)r.getCenterX() - 14 + sideOffset;
                y = (int)r.getMinY() - 28 - 0;
            } else if (b.getSide() == 0) {
                x = (int)r.getCenterX() - 14 + sideOffset;
                y = (int)r.getMaxY() + 0;
            } else if (b.getSide() == 3) {
                x = (int)r.getMinX() - 28 - 0;
                y = (int)r.getCenterY() - 14 + sideOffset;
            } else if (b.getSide() == 2) {
                x = (int)r.getMaxX() + 0;
                y = (int)r.getCenterY() - 14 + sideOffset;
            }
            b.setLocation(x, y);
        }
    }

    @Override
    public void removeAllBuffers() {
        for (Buffer b : this.buffers) {
            this.graph.remove(b);
        }
        this.buffers.clear();
    }
}

