/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import view.Cell;

public class Selection
extends Cell {
    private Point2D start = new Point2D.Double(0.0, 0.0);

    public Selection() {
        super(-1, null);
    }

    public void setStartPoint(Point2D start) {
        this.start = start;
    }

    public Point2D getStartPoint() {
        return this.start;
    }

    public void updateSelection(Point2D end) {
        int x = Math.min((int)this.start.getX(), (int)end.getX());
        int y = Math.min((int)this.start.getY(), (int)end.getY());
        int width = Math.abs((int)this.start.getX() - (int)end.getX());
        int height = Math.abs((int)this.start.getY() - (int)end.getY());
        this.setBounds(x, y, width, height);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        BufferedImage dbImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D dbg = (Graphics2D)dbImage.getGraphics();
        dbg.setColor(new Color(0, 0, 0, 25));
        dbg.fillRect(0, 0, this.getWidth(), this.getHeight());
        float[] dash = new float[]{5.0f};
        dbg.setStroke(new BasicStroke(1.0f, 0, 0, 5.0f, dash, 0.0f));
        Polygon p = new Polygon();
        p.addPoint(0, 0);
        p.addPoint(this.getWidth() - 1, 0);
        p.addPoint(this.getWidth() - 1, this.getHeight() - 1);
        p.addPoint(0, this.getHeight() - 1);
        dbg.setColor(Color.BLACK);
        dbg.draw(p);
        ((Graphics2D)g).drawImage((Image)dbImage, 0, 0, this);
    }

    @Override
    public boolean isInRange(Point2D start, Point2D end) {
        return false;
    }
}

