/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import view.DraggableHost;
import view.Graph;
import view.Host;

public class StaticHost
extends Host {
    private DraggableHost draggableHost;
    private Graph dragGraph;

    public StaticHost(Graph g, Graph dragGraph, DraggableHost draggableHost) {
        super(0, g);
        this.dragGraph = dragGraph;
        this.draggableHost = draggableHost;
        this.position = new Point2D.Double(this.getX(), this.getY());
        this.setName("Host");
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.graph.isInSimulation()) {
            this.drag(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (!this.graph.isInSimulation()) {
            this.draggableHost.setVisible(true);
            this.pressedMousePositionX = arg0.getX();
            this.pressedMousePositionY = arg0.getY();
            this.mouseDragged(arg0);
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.draggableHost.setVisible(false);
        this.draggableHost.createHost();
    }

    @Override
    protected void drag(MouseEvent e) {
        Point currentPos = new Point((int)this.getBounds().getX(), (int)this.getBounds().getY());
        Point newPos = new Point((int)((double)e.getX() + currentPos.getX() - (double)this.pressedMousePositionX + (double)this.dragGraph.getX()), (int)((double)e.getY() + currentPos.getY() - (double)this.pressedMousePositionY) + this.dragGraph.getY());
        this.draggableHost.setBounds(new Rectangle(newPos, new Dimension((int)this.getBounds().getWidth(), (int)this.getBounds().getHeight())));
    }
}

