/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import view.DraggableRouter;
import view.Graph;
import view.Router;

public class StaticRouter
extends Router {
    private DraggableRouter draggableRouter;
    private Graph dragGraph;

    public StaticRouter(Graph g, Graph dragGraph, DraggableRouter draggableRouter) {
        super(0, g);
        this.dragGraph = dragGraph;
        this.draggableRouter = draggableRouter;
        this.position = new Point2D.Double(this.getX(), this.getY());
        this.setName("Router");
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.graph.isInSimulation()) {
            this.drag(e);
        }
    }

    @Override
    protected void drag(MouseEvent e) {
        Point currentPos = new Point((int)this.getBounds().getX(), (int)this.getBounds().getY());
        Point newPos = new Point((int)((double)e.getX() + currentPos.getX() - (double)this.pressedMousePositionX + (double)this.dragGraph.getX()), (int)((double)e.getY() + currentPos.getY() - (double)this.pressedMousePositionY) + this.dragGraph.getY());
        this.draggableRouter.setBounds(new Rectangle(newPos, new Dimension((int)this.getBounds().getWidth(), (int)this.getBounds().getHeight())));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (!this.graph.isInSimulation()) {
            this.draggableRouter.setVisible(true);
            this.pressedMousePositionX = arg0.getX();
            this.pressedMousePositionY = arg0.getY();
            this.mouseDragged(arg0);
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.draggableRouter.setVisible(false);
        this.draggableRouter.createRouter();
    }
}

