/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class VertexIcon
extends JPanel {
    private static final int BORDER_SIZE = 5;
    BufferedImage icon;

    public VertexIcon() {
        this.setBackground(null);
        this.repaint();
    }

    public void setIcon(String file) {
        try {
            URL url = this.getClass().getClassLoader().getResource(file);
            this.icon = ImageIO.read(url);
        }
        catch (MalformedURLException e) {
            System.out.println("Could not load '" + file + "'. Should continue though.");
        }
        catch (IOException e) {
            System.out.println("Could not load '" + file + "'. Should continue though.");
        }
        this.resize();
    }

    public void resize() {
        this.repaint();
        if (this.icon != null) {
            this.setPreferredSize(new Dimension(this.icon.getWidth() + 10, this.icon.getHeight() + 10));
            this.setBounds(0, 0, 10 + this.icon.getWidth(), 10 + this.icon.getHeight());
        }
    }

    public int getPanelHeight() {
        return 10 + this.icon.getHeight();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        ((Graphics2D)g).drawImage((Image)this.icon, (this.getWidth() - this.icon.getWidth()) / 2, 0, this);
    }
}

