/*
 * Decompiled with CFR 0.152.
 */
package view.tests;

import events.EventArgs;
import events.HostState;
import events.RouterState;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import junit.framework.TestCase;
import model.Model;
import org.junit.Test;
import view.Device;
import view.DraggableHost;
import view.DraggableRouter;
import view.GUI;
import view.Graph;
import view.StaticHost;
import view.StaticRouter;
import view.tests.PseudoController;

public class DeviceCreationTest
extends TestCase {
    private static final double hostX = 100.0;
    private static final double hostY = 100.0;
    private static final double routerX = 150.0;
    private static final double routerY = 150.0;
    private static final double graphWidth = 500.0;
    private static final double graphHeight = 500.0;
    private GUI gui;
    private Graph graph;
    private DraggableHost host;
    private DraggableRouter router;
    private StaticHost staticHost;
    private StaticRouter staticRouter;
    private PseudoController c;
    private HostState returnHost;
    private RouterState returnRouter;

    public void setupTest() {
        Model m = new Model();
        this.c = new PseudoController(this);
        try {
            this.gui = new GUI(m.loadSettings(), this.c);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.graph = new Graph(this.gui);
        this.graph.setBounds(new Rectangle(500, 500));
        this.host = new DraggableHost(this.graph, 100, 100);
        this.staticHost = new StaticHost(this.graph, this.graph, this.host);
        this.staticHost.mouseReleased(this.getDragEvent(this.staticHost, 100.0, 100.0));
        this.router = new DraggableRouter(this.graph, 150, 150);
        this.staticRouter = new StaticRouter(this.graph, this.graph, this.router);
        this.staticRouter.mouseReleased(this.getDragEvent(this.staticRouter, 150.0, 150.0));
    }

    private MouseEvent getDragEvent(Device d, double x, double y) {
        MouseEvent event = null;
        if (d instanceof StaticHost) {
            event = new MouseEvent(this.staticHost, 1234, System.currentTimeMillis(), 0, (int)x, (int)y, 1, false);
        } else if (d instanceof StaticRouter) {
            event = new MouseEvent(this.staticRouter, 1234, System.currentTimeMillis(), 0, (int)x, (int)y, 1, false);
        }
        return event;
    }

    @Test
    public void test() {
        this.setupTest();
        this.testCorrectness(this.returnHost.isNew(), 100.0, 100.0, 500.0, 500.0, this.returnHost.getX(), this.returnHost.getY());
        this.testCorrectness(this.returnRouter.isNew(), 150.0, 150.0, 500.0, 500.0, this.returnRouter.getX(), this.returnRouter.getY());
    }

    private void testCorrectness(boolean isNew, double x, double y, double graphWidth, double graphHeight, int realX, int realY) {
        DeviceCreationTest.assertTrue(isNew);
        double xPos = x / graphWidth * 1000.0;
        double yPos = y / graphHeight * 1000.0;
        DeviceCreationTest.assertEquals((int)xPos, realX);
        DeviceCreationTest.assertEquals((int)yPos, realY);
    }

    public void sendState(EventArgs s) {
        if (s instanceof HostState) {
            this.returnHost = (HostState)s;
        } else if (s instanceof RouterState) {
            this.returnRouter = (RouterState)s;
        }
    }
}

